<?php
/*

Copyright (c)2004 DuckCorp(tm)



This file is part of EMIR 

EMIR is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

EMIR is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with EMIR  if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

define('CONF', "/etc/emir.conf");
define('OUTPUT_DIR', "/var/lib/emir/");


define('DFTK_ROOT_PATH', "/usr/share/dftk/");
require_once(DFTK_ROOT_PATH."ai/inc.php");
require_once(DFTK_ROOT_PATH."language/inc.php");
require_once(DFTK_ROOT_PATH."trace/inc.php");
require_once(DFTK_ROOT_PATH."utilityfct/inc.php");
$langmgr =& new DftkDaLanguageManager();
$tracemgr =& new DftkDaTraceManager($langmgr);



$domxml = domxml_open_file(CONF);
$tree = xmlhasharray($domxml);


// Get base infos
$tree2 = $tree['emir'];

$infos = $tree2['global_infos'][0];
# defaults
$shell = "/bin/sh";
$echo = "/bin/echo";
$ifconfig = "/sbin/ifconfig";
$iptables = "/sbin/iptables";
$ip6tables = "/sbin/ip6tables";
if ($infos['path_list'])
{
	foreach ($infos['path_list'][0][path] as $key => $val)
	{
		if ($val['dx_properties']['prog'] == "shell")
			$shell = $val['dx_text'];
		if ($val['dx_properties']['prog'] == "echo")
			$echo = $val['dx_text'];
		if ($val['dx_properties']['prog'] == "ifconfig")
			$ifconfig = $val['dx_text'];
		if ($val['dx_properties']['prog'] == "iptables")
			$iptables = $val['dx_text'];
		if ($val['dx_properties']['prog'] == "ip6tables")
			$ip6tables = $val['dx_text'];
	}
}

$g_ifs = array();
$g_hosts = array();
$hosts_ifs = get_infos($infos['host_list'][0]['host_infos'], array('host_if' => array('ip4', 'ip6', 'mac')));
foreach ($hosts_ifs as $host_name => $if_info)
{
	foreach ($if_info['host_if'] as $if_name =>$if_data)
	{
		$g_ifs[$if_name] = $if_data;
		$g_hosts[$host_name][] = $if_name;
	}
}
$g_routers = array();
$hosts_ifs = get_infos($infos['router_list'][0]['router_infos'], array('host_if' => array('ip4', 'ip6', 'mac')));
foreach ($hosts_ifs as $host_name => $if_info)
{
	foreach ($if_info['host_if'] as $if_name =>$if_data)
	{
		$g_ifs[$if_name] = $if_data;
		$g_hosts[$host_name][] = $if_name;
		array_push($g_routers, $host_name);
	}
}
$g_routers = array_unique($g_routers);

$g_host_groups = array();
$host_groups = get_infos($infos['host_group_list'][0]['host_group_infos'], array('host', 'if'));
if ($infos['host_group_list'])
{
	foreach ($infos['host_group_list'][0]['host_group_infos'] as $group_data)
	{
		$group_name = $group_data['name'][0]['dx_text'];
		if ($group_data['if'])
			foreach ($group_data['if'] as $if_data)
				$g_host_groups[$group_name][] = $if_data['dx_text'];

		if ($group_data['host'])
			foreach ($group_data['host'] as $host_data)
				foreach ($g_hosts[$host_data['dx_text']] as $if)
					$g_host_groups[$group_name][] = $if;
	}
}

$output_iface = get_infos($infos['out_interface'], array('if'));
foreach ($output_iface as $z)
	$output = $z;
$input_iface = get_infos($infos['in_interface'], array('if', 'addr_range'));
foreach ($input_iface as $z)
	$input = $z;
$addr_ranges = get_infos($infos['addr_range_list'][0]['addr_range_infos'], array('arange4' => array('ip4', 'mask'), 'arange6' => array('ip6', 'prefix')));

$local_range = $addr_ranges[$output['addr_range']];
$z = shell_exec($ifconfig." ".$input['if']." | grep 'inet addr:'");
preg_match("/\d+\.\d+\.\d+\.\d+/", $z, $val);
$gtw_ip4 = $val[0];
$z = shell_exec($ifconfig." ".$output['if']." | grep 'Scope:Global'");
preg_match("/: (.+)\//", $z, $val);
$gtw_ip6 = $val[1];
$gtw_mask = get_subnet($gtw_ip4);

$routers = array();
foreach ($g_routers as $rt)
{
	foreach ($g_hosts[$rt] as $if_name)
	{
		$routers[$rt]['ips'][$g_ifs[$if_name]['ip4']] = $g_ifs[$if_name]['mac'];
	}
}
$subnets = find_subnets($routers);
$node_list = create_nodes($routers, $subnets);
$pathfinder =& new DftkAiIDAstar($tracemgr);
$pathfinder->set_cost_fct("simple_cost");
$pathfinder->set_heuristic_fct("straight_line_heuristic");
$pathfinder->set_successor_selection_fct("sel");
$pathfinder->set_node_list($node_list);

foreach ($g_ifs as $if_name => $if_data)
{
	$mask = get_subnet($if_data['ip4']);
	if ($mask != $gtw_mask)
	{
		$r =& $pathfinder->get_path($mask, $gtw_mask);
		$path = $r->get_result('path');
		if ($path)
		{
			$node = array_pop($path);
			$mac = $node[1][1];
			$g_ifs[$if_name]['mac'] = $mac;
		}
	}
}

/*
print_r($g_ifs);
print_r($g_hosts);
print_r($g_routers);
print_r($g_host_groups);
print replace_to_str(replace_host("bla bla #myh_ip4 !!! #myh_zhjj #myh_ip6 plop #myh_mac ddd\n", "myh", "adsl-servers"));
print replace_to_str(replace_host("bla bla #myh_ip4 !!! myh_zhjj #myh_ip6 plop #myh_mac ddd\n", "myh", "adsl-servers"));
exit(0);
*/



// Generate config
$rs ="\n";
$rs.= "# MARK\n";
$rs.= $iptables." -t filter -N emir_configuration\n";
$rs.="\n";

// DOMXML is buggy, cannot retrieve root node attributes
//if ($tree2['dx_properties']['enabled'])
//{

$rs.= "# IPv4 :\n\n";
$ipv4 = $tree2['ipv4_rules'][0];
if ($ipv4['dx_properties']['enabled'])
{
	$security = $ipv4['security'][0];

	// Logging parameters
	$logging_p = $ipv4['logging'][0];
	global $logging;
	$logging = array('enabled' =>  $logging_p['dx_properties']['enabled']);
	if ($logging['enabled'])
	{
		$params = array("limit_rate", "limit_burst", "log_level", "log_ip_options", "log_tcp_options");
		foreach ($params as $p)
			$logging[$p] = $logging_p[$p][0]['dx_text'];
	}

	$rs.= "# IPv4--forwarding :\n\n";
	$forwarding = $ipv4['forwarding'][0];
	if ($forwarding['dx_properties']['activate'])
	{
		$rs.= $echo." 1 > /proc/sys/net/ipv4/ip_forward\n";
	}
	if ($forwarding['dx_properties']['nat'])
	{
		$range = $addr_ranges[$input['addr_range']]['arange4'];
		$rs.= $iptables." -t nat -A POSTROUTING -s ".$range['ip4']."/".$range['mask']." -o ".$output['if']." -j MASQUERADE\n";
	}


	$rs.= "# IPv4--pmserv :\n\n";
	$pmserv = $ipv4['portmapped_services'][0];
	if ($pmserv['dx_properties']['enabled'])
	{
		$forward_in_rule_pm = "";
		$rs.= $iptables." -t nat -N port_mapping\n";
		$s = get_infos($pmserv['pservice'], array('proto', 'outside_port', 'if', 'port'));
		$i = 0;
		foreach ($s as $key => $val)
		{
			if ($pmserv['pservice'][$i]['dx_properties']['enabled'])
			{
				if (($val['proto'] == "tcp/udp") || ($val['proto'] == "udp/tcp"))
					$plist = array("tcp", "udp");
				else
					$plist = array($val['proto']);
				$host = $g_ifs[$val['if']]['ip4'];

				for ($j=0; $j<count($plist); $j++)
				{
					if ($val['outside_port'])
						$rs.= $iptables." -t nat -A port_mapping -p ".$plist[$j]." --dport ".$val['outside_port']." -j DNAT --to-destination ".$host.":".$val['port']."\t# ".$key."\n";
					else
						$rs.= $iptables." -t nat -A port_mapping -p ".$plist[$j]." --dport ".$val['port']." -j DNAT --to-destination ".$host."\t\t# ".$key."\n";
					$forward_in_rule_pm.= $iptables." -t filter -A forward_in_packets_allowed -p ".$plist[$j]." -d ".$host." --dport ".$val['port']." -m state --state NEW,ESTABLISHED,RELATED -j ACCEPT\n";
				}
			}
			else
				$rs.= "#       remote service '".$key."' disabled\n";
			$i++;
		}
		$rs.= $iptables." -t nat -A PREROUTING -i ".$output['if']." -j port_mapping\n";
	}
	else
	{
		$rs.= "#    disabled\n";
	}
	$rs.= "\n";

	if ($forwarding['dx_properties']['state_filtering'])
	{
		$rs.= create_rule('forwarding', "[EMIR] Bad fwding state : ");
		
		$forward_in_rule = "forward_in_packets_allowed";
		$rs.= $iptables." -t filter -N forward_in_packets_allowed\n";
		$rs.= $forward_in_rule_pm;
		$rs.= $iptables." -t filter -A forward_in_packets_allowed -m state --state ESTABLISHED,RELATED -j ACCEPT\n";
		$rs.= $iptables." -t filter -A forward_in_packets_allowed -j ".rule('forwarding', $forwarding['dx_properties']['bad'])."\n";
		$forward_out_rule = "forward_out_packets_allowed";
		$rs.= $iptables." -t filter -N forward_out_packets_allowed\n";
		$rs.= $iptables." -t filter -A forward_out_packets_allowed -m state --state NEW,ESTABLISHED,RELATED -j ACCEPT\n";
		$rs.= $iptables." -t filter -A forward_out_packets_allowed -j ".rule('forwarding', $forwarding['dx_properties']['bad'])."\n";
	}
	else
	{
		$forward_in_rule = "ACCEPT";
		$forward_out_rule = "ACCEPT";
	}
	$rs.= "\n";

	$rs.= "# IPv4--access :\n\n";
	$access = $ipv4['access'][0];
	if ($access['dx_properties']['enabled'])
	{
		$rs.= "# IPv4--security--clirestr :\n\n";
		$clirestr = $security['clients_restrictions'][0];
		if ($security['dx_properties']['enabled'] && $clirestr['dx_properties']['enabled'])
		{
			$rs.= create_rule('clirestr', "[EMIR] Restricted client : ");

			for ($k=0; $k<count($clirestr['restricted_clients'])+1; $k++)
				$rs.= $iptables." -t filter -N clients_restrictions_".$k."\n";
			for ($k=0; $k<count($clirestr['restricted_clients']); $k++)
			{
				$destrestr = $clirestr['restricted_clients'][$k];
				if ($destrestr['dx_properties']['enabled'])
				{
					$bad = $clirestr['dx_properties']['bad'];
					if (isset($destrestr['dx_properties']['bad']))
						$bad = $destrestr['dx_properties']['bad'];

					$res = array();
					$dest_tpl = $iptables." -t filter -A clients_restrictions_".$k." -s #clirestr_cli_ip4 -o ".$output['if'];
					for ($i=0; $i<count($destrestr['restricted_destinations'][0]['destination']); $i++)
					{
						$dest = $destrestr['restricted_destinations'][0]['destination'][$i];
						$policy = $dest['dx_properties']['policy'];
						$repl = $dest_tpl;
						if ($dest['service_info'])
							$repl.= " -p #clirestr_dest_proto --dport #clirestr_dest_port";
						if ($dest['host'])
							$repl.= " -d #clirestr_dest_ip4";
						if ($dest['addr_range'])
							$repl.= " -d #clirestr_dest_range_ip4/#clirestr_dest_range_mask";
						$pp = array($dest['service_info'][0]['port'][0]['dx_text'], $dest['service_info'][0]['proto'][0]['dx_text']);
						$res = replace_addr_range(replace_host(replace_portproto(array($repl), "clirestr_dest", $pp), "clirestr_dest", $dest['host'][0]['dx_text']), "clirestr_dest_range", $dest['addr_range'][0]['dx_text']);

						for ($j=0; $j<count($destrestr['clients']); $j++)
						{
							$client = $destrestr['clients'][$j];
							$selection = $destrestr['clients'][$j]['dx_properties']['selection'];
							if ($policy == "deny")
							{
								if ($selection == "list")
								{
									$res2 = tab_append($res, " -j ".rule('clirestr', $bad)."\n");
									foreach ($client['host'] as $h)
										$rs.= replace_to_str(replace_host($res2, "clirestr_cli", $h['dx_text']));
								}
								else
								{
									$res2 = tab_append($res, " -j clients_restrictions_".($k+1)."\n");
									foreach ($client['host'] as $h)
										$rs.= replace_to_str(replace_host($res2, "clirestr_cli", $h['dx_text']));
									$res2 = tab_append($res, " -j ".rule('clirestr', $bad)."\n");
									$rs.= replace_to_str(replace_tag($res2, "clirestr_cli_ip4", "0.0.0.0/0"));
								}
							}
							else
							{
								if ($selection == "list")
								{
									$res2 = tab_append($res, " -j clients_restrictions_".($k+1)."\n");
									foreach ($client['host'] as $h)
										$rs.= replace_to_str(replace_host($res2, "clirestr_cli", $h['dx_text']));
									$res2 = tab_append(array($dest_tpl), " -j ".rule('clirestr', $bad)."\n");
									foreach ($client['host'] as $h)
										$rs.= replace_to_str(replace_host($res2, "clirestr_cli", $h['dx_text']));
								}
								else
								{
									$res2 = tab_append(array($dest_tpl), " -j clients_restrictions_".($k+1)."\n");
									foreach ($client['host'] as $h)
										$rs.= replace_to_str(replace_host($res2, "clirestr_cli", $h['dx_text']));
									$res2 = tab_append($res, " -j clients_restrictions_".($k+1)."\n");
									$rs.= replace_to_str(replace_tag($res2, "clirestr_cli_ip4", "0.0.0.0/0"));
									$res2 = tab_append(array($dest_tpl), " -j ".rule('clirestr', $bad)."\n");
									$rs.= replace_to_str(replace_tag($res2, "clirestr_cli_ip4", "0.0.0.0/0"));
								}
							}
						}
					}
				}
				$rs. $iptables." -t filter -A FORWARD -o ".$output['if']." -j clients_restrictions_0";
			}
		}
		else
		{
			$rs.= "#    disabled\n";
		}
		$rs.= "\n";

		$rs.= "# IPv4--security--advrestr :\n\n";
		$advrestr = $security['advanced_restrictions'][0];
		if ($security['dx_properties']['enabled'] && $advrestr['dx_properties']['enabled'])
		{
			foreach ($advrestr['restriction'] as $restr)
			{
				if ($restr['dx_properties']['enabled'] && $restr['rule'][0]['dx_text'])
				{
					// custom rules => custom logging
					$rule = $restr['rule'][0]['dx_text'];
					$rule = preg_replace("/#iface_in/", $input['if'], $rule);
					$rule = preg_replace("/#iface_out/", $output['if'], $rule);
					$comment = $restr['comment'][0]['dx_text'];
					$rs.= $iptables." -t filter -A FORWARD ".$rule."\t# ".$comment."\n";
				}
			}
		}
		else
		{
			$rs.= "#    disabled\n";
		}
		$rs.= "\n";
	
		$rs.= "# IPv4--access--everybody :\n\n";
		$everybody = $access['everybody'][0];
		if ($everybody['dx_properties']['enabled'])
		{
			$rs.= $iptables." -t filter -N global_port_nat_in\n";
			$rs.= $iptables." -t filter -N global_port_nat_out\n";
			$oa = get_infos($everybody['open_access'], array('proto', 'port'));
			$i = 0;
			foreach ($oa as $key => $val)
			{
				if ($everybody['open_access'][$i]['dx_properties']['enabled'])
				{
					if (($val['proto'] == "tcp/udp") || ($val['proto'] == "udp/tcp"))
						$plist = array("tcp", "udp");
					else
						$plist = array($val['proto']);

					for ($j=0; $j<count($plist); $j++)
					{
						$rs.= $iptables." -t filter -A global_port_nat_in -p ".$plist[$j]." --dport ".$val['port']." -j ".$forward_in_rule."\t\t# ".$key."\n";
						$rs.= $iptables." -t filter -A global_port_nat_out -p ".$plist[$j]." --dport ".$val['port']." -j ".$forward_out_rule."\t\t# ".$key."\n";
					}
				}
				else
					$rs.= "#       open access for '".$key."' not authorized\n";
				$i++;
			}
			$rs.= $iptables." -t filter -A FORWARD -i ".$output['if']." -o ".$input['if']." -j global_port_nat_in\n";
			$rs.= $iptables." -t filter -A FORWARD -i ".$input['if']." -o ".$output['if']." -j global_port_nat_out\n";
		}
		else
		{
			$rs.= "#    disabled\n";
		}
		$rs.= "\n";

		$rs.= "# IPv4--access--mhost :\n\n";
		$member_hosts = $access['member_hosts'][0];
		if ($member_hosts['dx_properties']['enabled'])
		{
			$rs.= create_rule('access_mhost', "[EMIR] Unauthorized host : ");

			if ($member_hosts['dx_properties']['mac_filtering'])
				$repl = array(
					$iptables." -t filter -A mhost_filter_out -m mac --mac-source #mhost_mac -s #mhost_ip4 -j ".$forward_out_rule."\n",
					$iptables." -t filter -A mhost_filter_in -d #mhost_ip4 -j ".$forward_in_rule."\n"
					);
			else
				$repl = array(
					$iptables." -t filter -A mhost_filter_out -s #mhost_ip4 -j ".$forward_out_rule."\n",
					$iptables." -t filter -A mhost_filter_in -d #mhost_ip4 -j ".$forward_in_rule."\n"
					);
			$rs.= $iptables." -t filter -N mhost_filter_in\n";
			$rs.= $iptables." -t filter -N mhost_filter_out\n";
			foreach ($member_hosts['mhost'] as $mhost => $minfos)
			{
				$h = $minfos['dx_text'];
				if ($minfos['dx_properties']['enabled'])
					$rs.= replace_to_str(replace_host($repl, "mhost", $h));
				else
					$rs.= "#       host '".$h."' not authorized\n";
			}
			$rs.= $iptables." -t filter -A mhost_filter_in -j ".rule('access_mhost', $member_hosts['dx_properties']['bad'])."\n";
			$rs.= $iptables." -t filter -A mhost_filter_out -j ".rule('access_mhost', $member_hosts['dx_properties']['bad'])."\n";
			$rs.= $iptables." -t filter -A FORWARD -i ".$input['if']." -o ".$output['if']." -j mhost_filter_out\n";
			$rs.= $iptables." -t filter -A FORWARD -i ".$output['if']." -o ".$input['if']." -j mhost_filter_in\n";
		}
		else
		{
			$rs.= "#    disabled\n";
		}
		$rs.= "\n";

		$rs.= "# IPv4--access--muser :\n\n";
		$member_users = $access['member_users'][0];
		if ($member_users['dx_properties']['enabled'])
		{
			$rs.= create_rule('access_muser', "[EMIR] Unauthorized user : ");

			$rs.= $iptables." -t filter -N user_filter\n";
			foreach ($member_users['muser'] as $muser => $minfos)
			{
				if ($minfos['dx_properties']['enabled'])
				{
					$u = $minfos['dx_text'];
					$rs.= $iptables." -t filter -A user_filter -m owner --uid-owner ".$u." -j ACCEPT\n";
				}
				else
					$rs.= "#       user '".$u."' not authorized\n";
			}
			$rs.= $iptables." -t filter -A user_filter -j ".rule('access_muser', $member_users['dx_properties']['bad'])."\n";
			$rs.= $iptables." -t filter -A OUTPUT -o ".$output['if']." -j user_filter\n";
		}
		else
		{
			$rs.= "#    disabled\n";
		}
		$rs.= "\n";
	}
	else
	{
		$rs.= "#    disabled\n";
	}
	$rs.= "\n";


	$rs.= "# IPv4--security :\n\n";
	if ($security['dx_properties']['enabled'])
	{
		$rs.= $iptables." -A INPUT -i lo -j ACCEPT\n";
		$rs.= $iptables." -A INPUT -i ".$input['if']." -j ACCEPT\n";
		$rs.= "\n";

		$rs.= "# IPv4--ip-stack-settings :\n\n";
		$ipstack = $security['ip_stack_settings'][0];
		if ($ipstack['dx_properties']['enabled'])
		{
			$rs.= $echo." 1 > /proc/sys/net/ipv4/conf/all/rp_filter\n";
			$rs.= $echo." 0 > /proc/sys/net/ipv4/conf/all/accept_source_route\n";
			$rs.= $echo." 0 > /proc/sys/net/ipv4/conf/all/accept_redirects\n";
			$rs.= $echo." 1 > /proc/sys/net/ipv4/tcp_syncookies\n";
			$rs.= $echo." 1 > /proc/sys/net/ipv4/icmp_echo_ignore_broadcasts\n";
		}
		else
		{
			$rs.= "#    disabled\n";
		}
		$rs.= "\n";

		$rs.= "# IPv4--security--antispoof :\n\n";
		$antispoof = $security['anti_spoofing'][0];
		if ($antispoof['dx_properties']['enabled'])
		{
			$rs.= create_rule('antispoof', "[EMIR] Spoofing host : ");
			$router = $antispoof['router_if'][0]['dx_text'];
			if ($router)
			{
				$ipr = $g_ifs[$router]['ip4'];
				$rs.= $iptables." -t mangle -A PREROUTING -i ".$output['if']." -s ".$ipr." -j ACCEPT\n";
			}
			$dmz = $antispoof['dmz_range'][0]['dx_text'];
			if ($dmz)
			{
				$ranged = $addr_ranges[$dmz]['arange4']['ip4'];
				$maskd = $addr_ranges[$dmz]['arange4']['mask'];
				$rs.= $iptables." -t mangle -A PREROUTING -i ".$output['if']." -s ".$ranged."/".$maskd." -j ACCEPT\n";
			}
			$rs.= $iptables." -t mangle -A PREROUTING -i ".$output['if']." -s 192.168.0.0/16 -j ".rule('antispoof', $antispoof['dx_properties']['bad'])."\n";
			$rs.= $iptables." -t mangle -A PREROUTING -i ".$output['if']." -s 10.0.0.0/8 -j ".rule('antispoof', $antispoof['dx_properties']['bad'])."\n";
			$rs.= $iptables." -t mangle -A PREROUTING -i ".$output['if']." -s 172.16.0.0/12 -j ".rule('antispoof', $antispoof['dx_properties']['bad'])."\n";
		}
		else
		{
			$rs.= "#    disabled\n";
		}
		$rs.= "\n";

		$rs.= "# IPv4--security--servrestr :\n\n";
		$servrestr = $security['services_restrictions'][0];
		if ($servrestr['dx_properties']['enabled'])
		{
			$rs.= create_rule('servrestr', "[EMIR] Restricted service : ");

			foreach ($servrestr['restricted_service'] as $serv)
			{
				if ($serv['dx_properties']['enabled'])
				{
					$bad = $servrestr['dx_properties']['bad'];
					if (isset($serv['dx_properties']['bad']))
						$bad = $serv['dx_properties']['bad'];

					if ($serv['dx_properties']['policy'] == "deny")
					{
						$repl01 = array($iptables." -t mangle -A PREROUTING -i ".$output['if']." -p #rserv_proto --dport #rserv_port -s #rserv_ip4 -j ".rule('servrestr', $bad)."\n");
						$repl02 = array($iptables." -t mangle -A PREROUTING -i ".$output['if']." -p #rserv_proto --dport #rserv_port -s #rserv_ip4/#rserv_mask -j ".rule('servrestr', $bad)."\n");
						$repl03 = array();
					}
					else
					{
						$repl01 = array($iptables." -t mangle -A PREROUTING -i ".$output['if']." -p #rserv_proto --dport #rserv_port -s #rserv_ip4 -j ACCEPT\n");
						$repl02 = array($iptables." -t mangle -A PREROUTING -i ".$output['if']." -p #rserv_proto --dport #rserv_port -s #rserv_ip4/#rserv_mask -j ACCEPT\n");
						$repl03 = array($iptables." -t mangle -A PREROUTING -i ".$output['if']." -p #rserv_proto --dport #rserv_port -j ".rule('servrestr', $bad)."\n");
					}

					foreach ($serv['service_info'] as $serv_info)
					{
						$repl11 = array_merge(replace_portproto($repl01, "rserv", array($serv_info['port'][0]['dx_text'], $serv_info['proto'][0]['dx_text'])), $repl11);
						$repl12 = array_merge(replace_portproto($repl02, "rserv", array($serv_info['port'][0]['dx_text'], $serv_info['proto'][0]['dx_text'])), $repl12);
						$repl13 = array_merge(replace_portproto($repl03, "rserv", array($serv_info['port'][0]['dx_text'], $serv_info['proto'][0]['dx_text'])), $repl13);
					}
					$repl21 = array();
					if (is_array($serv['host']))
						foreach ($serv['host'] as $host_info)
							$repl21 = array_merge(replace_host($repl11, "rserv", $host_info['dx_text']), $repl21);
					$repl22 = array();
					if (is_array($serv['addr_range']))
						foreach ($serv['addr_range'] as $addr_range_info)
							$repl22 = array_merge(replace_addr_range($repl12, "rserv", $addr_range_info['dx_text']), $repl22);
					$rs.= replace_to_str(array_merge($repl21, $repl22, $repl13));
				}
			}
		}
		else
		{
			$rs.= "#    disabled\n";
		}
		$rs.= "\n";

		$rs.= "# IPv4--security--icmp :\n\n";
		$icmp = $security['icmp4_filtering'][0];
		if ($icmp['dx_properties']['enabled'])
		{
			$rs.= create_rule('icmp4', "[EMIR] Bad ICMP4 packet : ");
			$rs.= $iptables." -N icmp_allowed\n";
			foreach ($icmp['icmp_type_allowed'] as $ita)
			{
				$ita_t = $ita['dx_text'];
				$rs.= $iptables." -A icmp_allowed -p icmp --icmp-type ".$ita_t." -j ACCEPT\n";
			}
			$rs.= $iptables." -A icmp_allowed -p icmp -j ".rule('icmp4', $icmp['dx_properties']['bad'])."\n";
			$rs.= $iptables." -t filter -A INPUT -p icmp -i ".$output['if']." -j icmp_allowed\n";
		}
		else
		{
			$rs.= "#    disabled\n";
			$rs.= $iptables." -t filter -A INPUT -p icmp -i ".$output['if']." -j ACCEPT\n";
		}
		$rs.= "\n";

		$rs.= "# IPv4--security--localserv :\n\n";
		$localserv = $security['local_services'][0];
		if ($localserv['dx_properties']['enabled'])
		{
			$statef = $localserv['dx_properties']['state_filtering'];
			$allow_related = $localserv['dx_properties']['allow_related'];

			if ($statef || $allow_related)
				$rs.= create_rule('localserv_state', "[EMIR] Bad localserv state : ");

			if ($statef)
			{
				$rs.= $iptables." -t filter -N srv_packets_allowed\n";
				$rs.= $iptables." -t filter -A srv_packets_allowed -p tcp --syn -j ACCEPT\n";
				$rs.= $iptables." -t filter -A srv_packets_allowed -p tcp -m state --state ESTABLISHED,RELATED,NEW -j ACCEPT\n";
				$rs.= $iptables." -t filter -A srv_packets_allowed -p udp -m state --state ESTABLISHED,RELATED,NEW -j ACCEPT\n";
				$rs.= $iptables." -t filter -A srv_packets_allowed -j ".rule('localserv_state', $localserv['dx_properties']['bad'])."\n";
				$rs.= "\n";
			}

			$rs.= $iptables." -t filter -N tcpudp_allowed\n";
			$s = get_infos($localserv['lservice'], array('proto', 'port'));
			$i = 0;
			foreach ($s as $key => $val)
			{
				if ($localserv['lservice'][$i]['dx_properties']['enabled'])
				{
					if (($val['proto'] == "tcp/udp") || ($val['proto'] == "udp/tcp"))
						$plist = array("tcp", "udp");
					else
						$plist = array($val['proto']);

					for ($j=0; $j<count($plist); $j++)
					{
						if ($statef)
							$rs.= $iptables." -t filter -A tcpudp_allowed -p ".$plist[$j]." --dport ".$val['port']." -j srv_packets_allowed\t\t# ".$key."\n";
						else
							$rs.= $iptables." -t filter -A tcpudp_allowed -p ".$plist[$j]." --dport ".$val['port']." -j ACCEPT\t\t# ".$key."\n";
					}
				}
				else
					$rs.= "#       local service '".$key."' disabled\n";
				$i++;
			}
			$rs.= $iptables." -t filter -A INPUT -i ".$output['if']." -j tcpudp_allowed\n";

			if ($allow_related)
			{
				$rs.= $iptables." -t filter -A INPUT -p tcp --syn -j ".rule('localserv_state', $localserv['dx_properties']['bad'])."\n";
				$rs.= $iptables." -t filter -A INPUT -p tcp -m state --state ESTABLISHED,RELATED -j ACCEPT\n";
				$rs.= $iptables." -t filter -A INPUT -p udp -m state --state ESTABLISHED,RELATED -j ACCEPT\n";
			}

			$rs.= "\n";
			$rs.= create_rule('localserv', "[EMIR] Bad lserv access : ");
			$rs.= $iptables." -t filter -A INPUT -i ".$output['if']." -j ".rule('localserv_state', $localserv['dx_properties']['bad'])."\n";
		}
		else
		{
			$rs.= "#    disabled\n";
			$rs.= $iptables." -t filter -A INPUT -i ".$output['if']." -j ACCEPT\n";
		}
		$rs.= "\n";

		// out of security
		$rs.= $iptables." -P INPUT DROP\n";
		$rs.= "\n";
	}
	else
	{
		$rs.= "#    disabled\n";
	}
	$rs.= "\n";
}
else
{
	$rs.= "#    disabled\n";
}
$rs.= "\n";



$rs.= "# IPv6 :\n\n";
$ipv6 = $tree2['ipv6_rules'][0];
if ($ipv6['dx_properties']['enabled'])
{
	// Logging parameters
	$logging_p = $ipv6['logging'][0];
	global $logging;
	$logging = array('enabled' =>  $logging_p['dx_properties']['enabled']);
	if ($logging['enabled'])
	{
		$params = array("limit_rate", "limit_burst", "log_level", "log_ip_options", "log_tcp_options");
		foreach ($params as $p)
			$logging[$p] = $logging_p[$p][0]['dx_text'];
	}

	$rs.= "# IPv6--access :\n\n";
	$access = $ipv6['access6'][0];
	if ($access['dx_properties']['enabled'])
	{	
		$rs.= "# IPv6--access--mhost :\n\n";
		$member_hosts = $access['member_hosts'][0];
		if ($member_hosts['dx_properties']['enabled'])
		{
			$rs.= create_rule('access6_mhost', "[EMIR] Unauthorized host : ", false);

			if ($member_hosts['dx_properties']['mac_filtering'])
				$repl = array(
					$ip6tables." -t filter -A mhost_filter_out -m mac --mac-source #mhost_mac -s #mhost_ip6 -j ACCEPT\n",
					$ip6tables." -t filter -A mhost_filter_in -d #mhost_ip6 -j ACCEPT\n"
					);
			else
				$repl = array(
					$ip6tables." -t filter -A mhost_filter_out -s #mhost_ip6 -j ACCEPT\n",
					$ip6tables." -t filter -A mhost_filter_in -d #mhost_ip6 -j ACCEPT\n"
					);
			$rs.= $ip6tables." -t filter -N mhost_filter_in\n";
			$rs.= $ip6tables." -t filter -N mhost_filter_out\n";
			foreach ($member_hosts['mhost'] as $mhost => $minfos)
			{
				$h = $minfos['dx_text'];
				if ($minfos['dx_properties']['enabled'])
					$rs.= replace_to_str(replace_host($repl, "mhost", $h));
				else
					$rs.= "#       host '".$h."' not authorized\n";
			}
			$rs.= $ip6tables." -t filter -A mhost_filter_in -j ".rule('access6_mhost', $member_hosts['dx_properties']['bad'], false)."\n";
			$rs.= $ip6tables." -t filter -A mhost_filter_out -j ".rule('access6_mhost', $member_hosts['dx_properties']['bad'], false)."\n";
			$rs.= $ip6tables." -t filter -A FORWARD -i ".$input['if']." -o ".$output['if']." -j mhost_filter_out\n";
			$rs.= $ip6tables." -t filter -A FORWARD -i ".$output['if']." -o ".$input['if']." -j mhost_filter_in\n";
		}
		else
		{
			$rs.= "#    disabled\n";
		}
		$rs.= "\n";

		$rs.= "# IPv6--access--muser :\n\n";
		$member_users = $access['member_users'][0];
		if ($member_users['dx_properties']['enabled'])
		{
			$rs.= create_rule('access6_muser', "[EMIR] Unauthorized user : ", false);

			$rs.= $ip6tables." -t filter -N user_filter\n";
			foreach ($member_users['muser'] as $muser => $minfos)
			{
				if ($minfos['dx_properties']['enabled'])
				{
					$u = $minfos['dx_text'];
					$rs.= $ip6tables." -t filter -A user_filter -m owner --uid-owner ".$u." -j ACCEPT\n";
				}
				else
					$rs.= "#       user '".$u."' not authorized\n";
			}
			$rs.= $ip6tables." -t filter -A user_filter -j ".rule('access6_muser', $member_users['dx_properties']['bad'], false)."\n";
			$rs.= $ip6tables." -t filter -A OUTPUT -o ".$output['if']." -j user_filter\n";
		}
		else
		{
			$rs.= "#    disabled\n";
		}
		$rs.= "\n";
	}
	else
	{
		$rs.= "#    disabled\n";
	}
	$rs.= "\n";
}
else
{
	$rs.= "#    disabled\n";
}
$rs.= "\n";

//}



$rk = "\n";

$rk.="# Reset IPv4 policy :\n\n";
$rk.= $iptables." -t filter -P INPUT ACCEPT\n";
$rk.= $iptables." -t filter -P FORWARD ACCEPT\n";
$rk.= $iptables." -t filter -P OUTPUT ACCEPT\n";
$rk.= $iptables." -t nat -P PREROUTING ACCEPT\n";
$rk.= $iptables." -t nat -P POSTROUTING ACCEPT\n";
$rk.= $iptables." -t nat -P OUTPUT ACCEPT\n";
$rk.= $iptables." -t mangle -P PREROUTING ACCEPT\n";
$rk.= $iptables." -t mangle -P OUTPUT ACCEPT\n";
$rk.= "\n";
if ($ipv6['dx_properties']['enabled'])
{
	$rk.="# Reset IPv6 policy :\n\n";
	$rk.= $ip6tables." -t filter -P INPUT ACCEPT\n";
	$rk.= $ip6tables." -t filter -P FORWARD ACCEPT\n";
	$rk.= $ip6tables." -t filter -P OUTPUT ACCEPT\n";
	$rk.= $ip6tables." -t mangle -P PREROUTING ACCEPT\n";
	$rk.= $ip6tables." -t mangle -P OUTPUT ACCEPT\n";
	$rk.= "\n";
}

$rk.= "# Clear IPv4 rules :\n\n";
$rk.= $iptables." -t filter -F\n";
$rk.= $iptables." -t filter -X\n";
$rk.= $iptables." -t nat -F\n";
$rk.= $iptables." -t nat -X\n";
$rk.= $iptables." -t mangle -F\n";
$rk.= $iptables." -t mangle -X\n";
$rk.= "\n";
if ($ipv6['dx_properties']['enabled'])
{
	$rk.= "# Clear IPv6 rules :\n\n";
	$rk.= $ip6tables." -t filter -F\n";
	$rk.= $ip6tables." -t filter -X\n";
	$rk.= $ip6tables." -t mangle -F\n";
	$rk.= $ip6tables." -t mangle -X\n";
	$rk.= "\n";
}

$header = "#!".$shell."
#
# This file was generated by EMIR
# EMIR is Copyright (c)2004 DuckCorp(tm)
#

";

/*
print($header.$rs);
print("--------------------------------------------------\n");
print($header.$rk);
*/

$fp = fopen(OUTPUT_DIR."/emir_start.sh", "w");
fwrite($fp, $header.$rs);
fclose($fp);
chmod(OUTPUT_DIR."/emir_start.sh", 0755);

$fp = fopen(OUTPUT_DIR."/emir_stop.sh", "w");
fwrite($fp, $header.$rk);
fclose($fp);
chmod(OUTPUT_DIR."/emir_stop.sh", 0755);

function xmlhasharray(&$node)
{
	$branch = array();

	$type = $node->node_type();
	$branch['dx_type'] = $type;

	$attrs = $node->attributes();
	$nb = count($attrs);
	for($i=0; $i<$nb; $i++)
		$branch['dx_properties'][$attrs[$i]->name()] = $attrs[$i]->value();

	switch($type)
	{
	case XML_DOCUMENT_NODE :
		$root = $node->document_element();
		$root_name = $root->node_name();
		$branch['dx_document_root'] = $root_name;

		$doctype = $node->doctype();
		//$branch['dx_entities'] = $doctype->entities();
		//$branch['dx_internal_subset'] = $doctype->internal_subset();
		$branch['dx_dtd_document_root'] = $doctype->name();
		//$branch['dx_notations'] = $doctype->notations();
		$branch['dx_public_id'] = $doctype->public_id();
		$branch['dx_system_id'] = $doctype->system_id();

		$branch[$root_name] = xmlhasharray($root);
		break;
	case XML_ELEMENT_NODE :
		if ($node->has_child_nodes())
		{
			$children = $node->child_nodes();
			for ($i=0; $i<count($children); $i++)
			{
				$child =& $children[$i];
				$child_name = $child->node_name();

				switch ($child->node_type())
				{
				case XML_ELEMENT_NODE :
					if (!is_array($branch[$child_name]))
						$branch[$child_name] = array();
					$newbranch = xmlhasharray($child);
					$branch[$child_name][] = $newbranch;
					break;
				case XML_TEXT_NODE :
					$text = trim($child->node_value());
					if ($text)
						$branch['dx_text'] .= $text;
					break;
				case XML_COMMENT_NODE :
					$branch['dx_comments'][] = $child->node_value();
					break;
				}
			}
		}
	break;
	}

	return $branch;
}

function get_infos($node, $param_list)
{
	$result = array();
	
	for ($i=0; $i<count($node); $i++)
	{
		$tab = array();
		foreach ($param_list as $param => $param_list2)
		{
			if (is_integer($param))
				$param = $param_list2;
			$text = $node[$i][$param][0]['dx_text'];
			if (!$text)
			{
				if (is_array($param_list2))
					$tab[$param] = get_infos($node[$i][$param], $param_list2);
			}
			else
				$tab[$param] = $text;
		}
		$name = $node[$i]['name'][0]['dx_text'];
		if ($name)
			$result[$name] = $tab;
		else
			foreach ($tab as $key => $val)
				$result[$key] = $val;
	}

	return $result;
}

function replace_host($tab, $tag, $host)
{
	global		$g_ifs, $g_hosts, $g_routers, $g_host_groups;

	$ret = array();
	if (!is_array($tab))
		$tab = array($tab);

	if (array_key_exists($host, $g_ifs))
		$list = array($host);
	elseif (array_key_exists($host, $g_hosts))
		$list = $g_hosts[$host];
	elseif (array_key_exists($host, $g_host_groups))
		$list = $g_host_groups[$host];
	else
		return $tab;

	foreach ($tab as $el)
	{
		foreach ($list as $ifn)
		{
			$str = $el;
			if ($g_ifs[$ifn]['ip4'])
				$str = preg_replace("/#".$tag."_ip4/", $g_ifs[$ifn]['ip4'], $str);
			if ($g_ifs[$ifn]['ip6'])
				$str = preg_replace("/#".$tag."_ip6/", $g_ifs[$ifn]['ip6'], $str);
			if ($g_ifs[$ifn]['mac'])
				$str = preg_replace("/#".$tag."_mac/", $g_ifs[$ifn]['mac'], $str);
			$ret[] = $str;
		}
	}
	return $ret;
}

function replace_addr_range($tab, $tag, $addr_range)
{
	global		$addr_ranges;

	$ret = array();

	foreach ($tab as $el)
	{
		$str = $el;
		if ($addr_ranges[$addr_range]['arange4']['ip4'])
			$str =  preg_replace("/#".$tag."_ip4/", $addr_ranges[$addr_range]['arange4']['ip4'], $str);
		if ($addr_ranges[$addr_range]['arange4']['mask'])
			$str =  preg_replace("/#".$tag."_mask/", $addr_ranges[$addr_range]['arange4']['mask'], $str);
		if ($addr_ranges[$addr_range]['arange6']['ip6'])
			$str =  preg_replace("/#".$tag."_ip6/", $addr_ranges[$addr_range]['arange6']['ip6'], $str);
		if ($addr_ranges[$addr_range]['arange6']['prefix'])
			$str =  preg_replace("/#".$tag."_prefix/", $addr_ranges[$addr_range]['arange6']['prefix'], $str);
		$ret[] = $str;
	}

	return $ret;
}

function tab_append($tab, $txt)
{
	$ret = array();

	foreach ($tab as $el)
		$ret[] =  $el.$txt;

	return $ret;
}

function replace_tag($tab, $tag, $value)
{
	$ret = array();

	foreach ($tab as $el)
		$ret[] =  preg_replace("/#".$tag."/", $value, $el);

	return $ret;
}

function replace_port($tab, $tag, $port)
{
	$ret = array();

	foreach ($tab as $el)
		$ret[] =  preg_replace("/#".$tag."_port/", $port, $el);

	return $ret;
}

function replace_proto($tab, $tag, $proto)
{
	$ret = array();

	foreach ($tab as $el)
	{
		if (($proto == "tcp/udp") || ($proto == "udp/tcp"))
		{
			$ret[] =  preg_replace("/#".$tag."_proto/", "tcp", $el);
			$ret[] =  preg_replace("/#".$tag."_proto/", "udp", $el);
		}
		else
			$ret[] =  preg_replace("/#".$tag."_proto/", $proto, $el);
	}

	return $ret;
}

function replace_portproto($tab, $tag, $portproto)
{
	return replace_proto(replace_port($tab, $tag, $portproto[0]), $tag, $portproto[1]);
}

function replace_to_str($tab)
{
	$str = "";
	foreach ($tab as $el)
		if (!preg_match("/#\w+_\w+/", $el))
			$r.= $el;
	return $r;
}

// IPv4 C-class only
function get_subnet($ip)
{
	$z = explode(".", $ip);
	$z[3] = 0;
	return implode(".", $z);
}

function simple_cost($node_list, $node, $next_node)
{
        return 1;
}
                                                                                                                                                                         
                                                                                                                                                                         
function straight_line_heuristic($node_list, $start_node, $stop_node, $node, $next_node)
{
        return simple_cost($node_list, $node, $next_node);
}
                                                                                                                                                                         
                                                                                                                                                                         
function sel($node_list, $successor_list, $node)
{
        return 0;
}

function find_subnets(&$routers)
{
        $tab = array();
                                                                                                                                                                         
        foreach ($routers as $k => $v)
                foreach ($v['ips'] as $ip => $mac)
                        $tab[get_subnet($ip)][] = $k;
                                                                                                                                                                         
        foreach ($tab as $k => $v)
                $tab[$k] = array_unique($v);
                                                                                                                                                                         
        return $tab;
}

function create_nodes(&$routers, &$subnets)
{
        $tab = array();
                                                                                                                                                                         
        foreach ($subnets as $k => $v)
                foreach ($v as $r)
                        foreach ($routers[$r][ips] as $ip => $mac)
                                $tab[$k]['successors'][] = array(get_subnet($ip), array($r, $mac));
                                                                                                                                                                         
        return $tab;
}

function create_rule($key, $msg, $ipv4=true)
{
	global	$iptables, $ip6tables, $logging;

	if (!$logging['enabled'])
		return;

	if ($ipv4)
	{
		$command = $iptables;
		$reject_reason = "icmp-admin-prohibited";
	}
	else
	{
		$command = $ip6tables;
		$reject_reason = "icmp6-adm-prohibited";
	}

	$log = "";
	if ($logging['limit_rate'] || $logging['limit_burst'])
		$log.= " -m limit";
	if ($logging['limit_rate'])
		$log.= " --limit ".$logging['limit_rate'];
	if ($logging['limit_burst'])
		$log.= " --limit-burst ".$logging['limit_burst'];
	$log.= " -j LOG --log-prefix '".$msg."'";
	if ($logging['log_level'])
		$log.= " --log-level ".$logging['log_level'];
	if ($logging['log_ip_options'])
		$log.= " --log-ip-options";
	if ($logging['log_tcp_options'])
		$log.= " --log-tcp-options";

	$r = "";
	$r.= $command." -t filter -N rule_reject_".$key."\n";
	$r.= $command." -t filter -A rule_reject_".$key." ".$log."\n";
	$r.= $command." -t filter -A rule_reject_".$key." -j REJECT --reject-with ".$reject_reason."\n";
	$r.= $command." -t filter -N rule_drop_".$key."\n";
	$r.= $command." -t filter -A rule_drop_".$key." ".$log."\n";
	$r.= $command." -t filter -A rule_drop_".$key." -j DROP\n";
	$r.= "\n";
	return $r;
}

function rule($key, $type, $ipv4=true)
{
	global	$logging;

	if ($ipv4)
		$reject_reason = "icmp-admin-prohibited";
	else
		$reject_reason = "icmp6-adm-prohibited";

	// IPv6 stack bug workaround
	if (!$ipv4)
	{
		if ($type == "reject")
			$type = "drop";
		if ($type == "reject_log")
			$type = "drop_log";
	}

	switch($type)
	{
	case "reject" :
		return "REJECT --reject-with ".$reject_reason;
		break;
	case "drop" :
		return "DROP";
		break;
	case "reject_log" :
		if (!$logging['enabled'])
			return rule($key, "reject");
		return "rule_reject_".$key;
		break;
	case "drop_log" :
		if (!$logging['enabled'])
			return rule($key, "drop");
		return "rule_drop_".$key;
		break;
	default:
		return "DROP";
	}
}

/* futur developpement

function is_ip_in_range($ip, $net, $mask)
{
	$lnet = ip2long($net);
	$lip = ip2long($ip);

	$binnet = str_pad(decbin($lnet), 32, "0", "STR_PAD_LEFT");
	$firstpart = substr($binnet, 0, $mask);
	$binip = str_pad(decbin($lip), 32, "0", "STR_PAD_LEFT");
	$firstip = substr($binip ,0 ,$mask);

	return (strcmp($firstpart, $firstip) == 0);
}

function get_subnet($ip, $mask)
{
	$lip = ip2long($ip);

	$binip = str_pad(decbin($lip), 32, "0", "STR_PAD_LEFT");
	$firstip = substr($binip ,0 ,$mask);
	$subnet = str_pad($firstip, 32, "0", "STR_PAD_RIGHT");

	return long2ip(bindec($subnet));
}

*/

?>
