#! /bin/sh
#

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
SCRIPT=/usr/sbin/emir-ctrl
NAME=emir
DESC=EMIR

test -x ${SCRIPT} || exit 0

# Include emir defaults if available
if [[ -f /etc/default/${NAME} ]]
then
	. /etc/default/${NAME}
fi

set -e

case "$1" in
  start)
	if [[ "${start_at_boot}" != "true" ]]
	then
	    echo "${DESC} not started as requested"
	    exit 0
	fi
  	${SCRIPT} start
	;;
  stop)
  	${SCRIPT} stop
	;;
  restart|force-reload)
  	${SCRIPT} restart
	;;
  *)
	echo "Usage: /etc/init.d/${NAME} {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
