<?php
/*

Copyright (c)2004 DuckCorp(tm)



This file is part of EMIR 

EMIR is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

EMIR is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with EMIR  if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

define('CONF', "/etc/emir.conf");
define('OUTPUT_DIR', "/var/lib/emir/");


define('DFTK_ROOT_PATH', "/usr/share/dftk/");
require_once(DFTK_ROOT_PATH."ai/inc.php");
require_once(DFTK_ROOT_PATH."language/inc.php");
require_once(DFTK_ROOT_PATH."trace/inc.php");
require_once(DFTK_ROOT_PATH."utilityfct/inc.php");
$langmgr =& new DftkDaLanguageManager();
$tracemgr =& new DftkDaTraceManager($langmgr);



$domxml = domxml_open_file(CONF);
$tree = xmlhasharray($domxml);


// Get base infos
$tree2 = $tree['emir'];

$infos = $tree2['global_infos'][0];
$iptables = "";
$ip6tables = "";
foreach ($infos['path_list'][0][path] as $key => $val)
{
	if ($val['dx_properties']['prog'] == "iptables")
		$iptables = $val['dx_text'];
	if ($val['dx_properties']['prog'] == "ip6tables")
		$ip6tables = $val['dx_text'];
}

$g_ifs = array();
$g_hosts = array();
$hosts_ifs = get_infos($infos['host_list'][0]['host_infos'], array('host_if' => array('ip4', 'ip6', 'mac')));
foreach ($hosts_ifs as $host_name => $if_info)
{
	foreach ($if_info['host_if'] as $if_name =>$if_data)
	{
		$g_ifs[$if_name] = $if_data;
		$g_hosts[$host_name][] = $if_name;
	}
}
$g_routers = array();
$hosts_ifs = get_infos($infos['router_list'][0]['router_infos'], array('host_if' => array('ip4', 'ip6', 'mac')));
foreach ($hosts_ifs as $host_name => $if_info)
{
	foreach ($if_info['host_if'] as $if_name =>$if_data)
	{
		$g_ifs[$if_name] = $if_data;
		$g_hosts[$host_name][] = $if_name;
		array_push($g_routers, $host_name);
	}
}
$g_routers = array_unique($g_routers);

$g_host_groups = array();
$host_groups = get_infos($infos['host_group_list'][0]['host_group_infos'], array('host', 'if'));
foreach ($infos['host_group_list'][0]['host_group_infos'] as $group_data)
{
	$group_name = $group_data['name'][0]['dx_text'];
	if ($group_data['if'])
		foreach ($group_data['if'] as $if_data)
			$g_host_groups[$group_name][] = $if_data['dx_text'];

	if ($group_data['host'])
		foreach ($group_data['host'] as $host_data)
			foreach ($g_hosts[$host_data['dx_text']] as $if)
				$g_host_groups[$group_name][] = $if;
}

$output_iface = get_infos($infos['out_interface'], array('if'));
foreach ($output_iface as $z)
	$output = $z;
$input_iface = get_infos($infos['in_interface'], array('if', 'addr_range'));
foreach ($input_iface as $z)
	$input = $z;
$addr_ranges = get_infos($infos['addr_range_list'][0]['addr_range_infos'], array('arange4' => array('ip4', 'mask'), 'arange6' => array('ip6', 'prefix')));

$local_range = $addr_ranges[$output['addr_range']];
$z = shell_exec("/sbin/ifconfig ".$input['if']." | grep 'inet addr:'");
preg_match("/\d+\.\d+\.\d+\.\d+/", $z, $val);
$gtw_ip4 = $val[0];
$z = shell_exec("/sbin/ifconfig  ".$output['if']." | grep 'Scope:Global'");
preg_match("/: (.+)\//", $z, $val);
$gtw_ip6 = $val[1];
$gtw_mask = get_subnet($gtw_ip4);

$routers = array();
foreach ($g_routers as $rt)
{
	foreach ($g_hosts[$rt] as $if_name)
	{
		$routers[$rt]['ips'][$g_ifs[$if_name]['ip4']] = $g_ifs[$if_name]['mac'];
	}
}
$subnets = find_subnets($routers);
$node_list = create_nodes($routers, $subnets);
$pathfinder =& new DftkAiIDAstar($tracemgr);
$pathfinder->set_cost_fct("simple_cost");
$pathfinder->set_heuristic_fct("straight_line_heuristic");
$pathfinder->set_successor_selection_fct("sel");
$pathfinder->set_node_list($node_list);

foreach ($g_ifs as $if_name => $if_data)
{
	$mask = get_subnet($if_data['ip4']);
	if ($mask != $gtw_mask)
	{
		$r =& $pathfinder->get_path($mask, $gtw_mask);
		$path = $r->get_result('path');
		if ($path)
		{
			$node = array_pop($path);
			$mac = $node[1][1];
			$g_ifs[$if_name]['mac'] = $mac;
		}
	}
}

/*
print_r($g_ifs);
print_r($g_hosts);
print_r($g_routers);
print_r($g_host_groups);
print replace_to_str(replace_host("bla bla #myh_ip4 !!! #myh_zhjj #myh_ip6 plop #myh_mac ddd\n", "myh", "adsl-servers"));
print replace_to_str(replace_host("bla bla #myh_ip4 !!! myh_zhjj #myh_ip6 plop #myh_mac ddd\n", "myh", "adsl-servers"));
exit(0);
*/



// Generate config
$rs ="\n";
$rs.= "# MARK\n";
$rs.= $iptables." -t filter -N emir_configuration\n";
$rs.="\n";

$ipv4 = $tree2['ipv4_rules'][0];
if ($ipv4['dx_properties']['enabled'])
{
	$rs.= "# IPV4 :\n\n";

	$rs.= "# IPV4--nat :\n\n";
	$nat = $ipv4['nat'][0];
	if ($nat['dx_properties']['enabled'])
	{
		$range = $addr_ranges[$input['addr_range']]['arange4'];
		$rs.= $iptables." -t nat -A POSTROUTING -s ".$range['ip4']."/".$range['mask']." -o ".$output['if']." -j MASQUERADE\n";
	}
	else
	{
		$rs.= "#    disabled\n";
	}
	$rs.= "\n";

	$rs.= "# IPV4--access :\n\n";
	$access = $ipv4['access'][0];
	if ($access['dx_properties']['enabled'])
	{
		$rs.= "# IPV4--access--everybody :\n\n";
		$everybody = $access['everybody'][0];
		if ($everybody['dx_properties']['enabled'])
		{
			$rs.= $iptables." -t filter -N global_port_nat\n";
			$oa = get_infos($everybody['open_access'], array('proto', 'port'));
			$i = 0;
			foreach ($oa as $key => $val)
			{
				if ($everybody['open_access'][$i]['dx_properties']['enabled'])
				{
					if (($val['proto'] == "tcp/udp") || ($val['proto'] == "udp/tcp"))
						$plist = array("tcp", "udp");
					else
						$plist = array($val['proto']);

					for ($j=0; $j<count($plist); $j++)
						$rs.= $iptables." -t filter -A global_port_nat -p ".$plist[$j]." --dport ".$val['port']." -j ACCEPT\t\t# ".$key."\n";
				}
				else
					$rs.= "#       open access for '".$key."' not authorized\n";
				$i++;
			}
			$rs.= $iptables." -t filter -A FORWARD -i ".$input['if']." -o ".$output['if']." -j global_port_nat\n";
			$rs.= $iptables." -t filter -A FORWARD -i ".$output['if']." -o ".$input['if']." -j global_port_nat\n";
		}
		else
		{
			$rs.= "#    disabled\n";
		}
		$rs.= "\n";

		$rs.= "# IPV4--access--mhost :\n\n";
		$member_hosts = $access['member_hosts'][0];
		if ($member_hosts['dx_properties']['enabled'])
		{
			if ($member_hosts['dx_properties']['mac_filtering'])
				$repl = array(
					$iptables." -t filter -A mhost_filter_out -m mac --mac-source #mhost_mac -s #mhost_ip4 -j ACCEPT\n",
					$iptables." -t filter -A mhost_filter_in -d #mhost_ip4 -j ACCEPT\n"
					);
			else
				$repl = array(
					$iptables." -t filter -A mhost_filter_out -s #mhost_ip4 -j ACCEPT\n",
					$iptables." -t filter -A mhost_filter_in -d #mhost_ip4 -j ACCEPT\n"
					);
			$rs.= $iptables." -t filter -N mhost_filter_in\n";
			$rs.= $iptables." -t filter -N mhost_filter_out\n";
			foreach ($member_hosts['mhost'] as $mhost => $minfos)
			{
				$h = $minfos['dx_text'];
				if ($minfos['dx_properties']['enabled'])
					$rs.= replace_to_str(replace_host($repl, "mhost", $h));
				else
					$rs.= "#       host '".$h."' not authorized\n";
			}
			$rs.= $iptables." -t filter -A mhost_filter_in -j REJECT --reject-with icmp-net-prohibited\n";
			$rs.= $iptables." -t filter -A mhost_filter_out -j REJECT --reject-with icmp-net-prohibited\n";
			$rs.= $iptables." -t filter -A FORWARD -i ".$input['if']." -o ".$output['if']." -j mhost_filter_out\n";
			$rs.= $iptables." -t filter -A FORWARD -i ".$output['if']." -o ".$input['if']." -j mhost_filter_in\n";
		}
		else
		{
			$rs.= "#    disabled\n";
		}
		$rs.= "\n";

		$rs.= "# IPV4--access--muser :\n\n";
		$member_users = $access['member_users'][0];
		if ($member_users['dx_properties']['enabled'])
		{
			$rs.= $iptables." -t filter -N user_filter\n";
			foreach ($member_users['muser'] as $muser => $minfos)
			{
				if ($minfos['dx_properties']['enabled'])
				{
					$u = $minfos['dx_text'];
					$rs.= $iptables." -t filter -A user_filter -m owner --uid-owner ".$u." -j ACCEPT\n";
				}
				else
					$rs.= "#       user '".$u."' not authorized\n";
			}
			$rs.= $iptables." -t filter -A user_filter -j REJECT --reject-with icmp-net-prohibited\n";
			$rs.= $iptables." -t filter -A OUTPUT -o ".$output['if']." -j user_filter\n";
		}
		else
		{
			$rs.= "#    disabled\n";
		}
		$rs.= "\n";
	}
	else
	{
		$rs.= "#    disabled\n";
	}
	$rs.= "\n";


	$rs.= "# IPV4--pmserv :\n\n";
	$pmserv = $ipv4['portmapped_services'][0];
	if ($pmserv['dx_properties']['enabled'])
	{
		$rs.= $iptables." -t nat -N port_mapping\n";
		$s = get_infos($pmserv['pservice'], array('proto', 'outside_port', 'if', 'port'));
		$i = 0;
		foreach ($s as $key => $val)
		{
			if ($pmserv['pservice'][$i]['dx_properties']['enabled'])
			{
				if (($val['proto'] == "tcp/udp") || ($val['proto'] == "udp/tcp"))
					$plist = array("tcp", "udp");
				else
					$plist = array($val['proto']);
				$host = $g_ifs[$val['if']]['ip4'];

				for ($j=0; $j<count($plist); $j++)
				{
					if ($val['outside_port'])
						$rs.= $iptables." -t nat -A port_mapping -p ".$plist[$j]." --dport ".$val['outside_port']." -j DNAT --to-destination ".$host.":".$val['port']."\t# ".$key."\n";
					else
						$rs.= $iptables." -t nat -A port_mapping -p ".$plist[$j]." --dport ".$val['port']." -j DNAT --to-destination ".$host."\t\t# ".$key."\n";
				}
			}
			else
				$rs.= "#       remote service '".$key."' disabled\n";
			$i++;
		}
		$rs.= $iptables." -t nat -A PREROUTING -i ".$output['if']." -j port_mapping\n";
	}
	else
	{
		$rs.= "#    disabled\n";
	}
	$rs.= "\n";


	$rs.= "# IPV4--security :\n\n";
	$security = $ipv4['security'][0];
	if ($security['dx_properties']['enabled'])
	{
		$rs.= $iptables." -A INPUT -i lo -j ACCEPT\n";
		$rs.= $iptables." -A INPUT -i ".$input['if']." -j ACCEPT\n";
		$rs.= "\n";

		$rs.= "# IPV4--security--antispoof :\n\n";
		$antispoof = $security['anti_spoofing'][0];
		if ($antispoof['dx_properties']['enabled'])
		{
			$router = $antispoof['router_if'][0]['dx_text'];
			if ($router)
			{
				$ipr = $g_ifs[$router]['ip4'];
				$rs.= $iptables." -t mangle -A PREROUTING -i ".$output['if']." -s ".$ipr." -j ACCEPT\n";
			}
			$dmz = $antispoof['dmz_range'][0]['dx_text'];
			if ($dmz)
			{
				$ranged = $addr_ranges[$dmz]['arange4']['ip4'];
				$maskd = $addr_ranges[$dmz]['arange4']['mask'];
				$rs.= $iptables." -t mangle -A PREROUTING -i ".$output['if']." -s ".$ranged."/".$maskd." -j ACCEPT\n";
			}
			$rs.= $iptables." -t mangle -A PREROUTING -i ".$output['if']." -s 192.168.0.0/16 -j DROP\n";
			$rs.= $iptables." -t mangle -A PREROUTING -i ".$output['if']." -s 10.0.0.0/8 -j DROP\n";
			$rs.= $iptables." -t mangle -A PREROUTING -i ".$output['if']." -s 172.16.0.0/12 -j DROP\n";
		}
		else
		{
			$rs.= "#    disabled\n";
		}
		$rs.= "\n";

		$rs.= "# IPV4--security--localserv :\n\n";
		$localserv = $security['local_services'][0];
		if ($localserv['dx_properties']['enabled'])
		{
			$statef = $localserv['dx_properties']['state_filtering'];
			if ($statef)
			{
				$rs.= $iptables." -t filter -N packets_allowed\n";
				$rs.= $iptables." -t filter -A packets_allowed -p tcp --syn -j ACCEPT\n";
				$rs.= $iptables." -t filter -A packets_allowed -p tcp -m state --state ESTABLISHED,RELATED -j ACCEPT\n";
				$rs.= $iptables." -t filter -A packets_allowed -p udp -m state --state ESTABLISHED,RELATED -j ACCEPT\n";
				$rs.= $iptables." -t filter -A packets_allowed -j DROP\n";
				$rs.= "\n";
			}

			$rs.= $iptables." -t filter -N tcpudp_allowed\n";
			$s = get_infos($localserv['lservice'], array('proto', 'port'));
			$i = 0;
			foreach ($s as $key => $val)
			{
				if ($localserv['lservice'][$i]['dx_properties']['enabled'])
				{
					if (($val['proto'] == "tcp/udp") || ($val['proto'] == "udp/tcp"))
						$plist = array("tcp", "udp");
					else
						$plist = array($val['proto']);

					for ($j=0; $j<count($plist); $j++)
					{
						if ($statef)
							$rs.= $iptables." -t filter -A tcpudp_allowed -p ".$plist[$j]." --dport ".$val['port']." -j packets_allowed\t\t# ".$key."\n";
						else
							$rs.= $iptables." -t filter -A tcpudp_allowed -p ".$plist[$j]." --dport ".$val['port']." -j ACCEPT\t\t# ".$key."\n";
					}
				}
				else
					$rs.= "#       local service '".$key."' disabled\n";
				$i++;
			}
			$rs.= $iptables." -t filter -A INPUT -i ".$output['if']." -j tcpudp_allowed\n";
		}
		else
		{
			$rs.= "#    disabled\n";
		}
		$rs.= "\n";
		$rs.= "# IPV4--security--icmp :\n\n";
		$icmp = $security['icmp4_filtering'][0];
		if ($icmp['dx_properties']['enabled'])
		{
			$rs.= $iptables." -N icmp_allowed\n";
			foreach ($icmp['icmp_type_allowed'] as $ita)
			{
				$ita_t = $ita['dx_text'];
				$rs.= $iptables." -A icmp_allowed -p ICMP --icmp-type ".$ita_t." -j ACCEPT\n";
			}
			$rs.= $iptables." -A icmp_allowed -p ICMP -j DROP\n";
			$rs.= $iptables." -t filter -A INPUT -p ICMP -i ".$output['if']." -j icmp_allowed\n";
		}
		else
		{
			$rs.= "#    disabled\n";
			$rs.= $iptables." -t filter -A INPUT -p ICMP -i ".$output['if']." -j ACCEPT\n";
		}
		$rs.= "\n";

		$rs.= $iptables." -P INPUT DROP\n";
		$rs.= "\n";
	}
	else
	{
		$rs.= "#    disabled\n";
	}
	$rs.= "\n";

}


$rk = "\n";

$rk.="# Reset policy :\n\n";
$rk.= $iptables." -t filter -P INPUT ACCEPT\n";
$rk.= $iptables." -t filter -P FORWARD ACCEPT\n";
$rk.= $iptables." -t filter -P OUTPUT ACCEPT\n";
$rk.= $iptables." -t nat -P PREROUTING ACCEPT\n";
$rk.= $iptables." -t nat -P POSTROUTING ACCEPT\n";
$rk.= $iptables." -t nat -P OUTPUT ACCEPT\n";
$rk.= $iptables." -t mangle -P PREROUTING ACCEPT\n";
$rk.= $iptables." -t mangle -P OUTPUT ACCEPT\n";
$rk.= "\n";

$rk.= "# Clear rules :\n\n";
$rk.= $iptables." -t filter -F\n";
$rk.= $iptables." -t filter -X\n";
$rk.= $iptables." -t nat -F\n";
$rk.= $iptables." -t nat -X\n";
$rk.= $iptables." -t mangle -F\n";
$rk.= $iptables." -t mangle -X\n";
$rk.= "\n";

$header = "#!/bin/sh
#
# This file was generated by EMIR
# EMIR is Copyright (c)2004 DuckCorp(tm)
#

";

/*
print($header.$rs);
print("--------------------------------------------------\n");
print($header.$rk);
*/

$fp = fopen(OUTPUT_DIR."/emir_start.sh", "w");
fwrite($fp, $header.$rs);
fclose($fp);
chmod(OUTPUT_DIR."/emir_start.sh", 0755);

$fp = fopen(OUTPUT_DIR."/emir_stop.sh", "w");
fwrite($fp, $header.$rk);
fclose($fp);
chmod(OUTPUT_DIR."/emir_stop.sh", 0755);

function xmlhasharray(&$node)
{
	$branch = array();

	$type = $node->node_type();
	$branch['dx_type'] = $type;

	$attrs = $node->attributes();
	$nb = count($attrs);
	for($i=0; $i<$nb; $i++)
		$branch['dx_properties'][$attrs[$i]->name()] = $attrs[$i]->value();

	switch($type)
	{
	case XML_DOCUMENT_NODE :
		$root = $node->document_element();
		$root_name = $root->node_name();
		$branch['dx_document_root'] = $root_name;

		$doctype = $node->doctype();
		//$branch['dx_entities'] = $doctype->entities();
		//$branch['dx_internal_subset'] = $doctype->internal_subset();
		$branch['dx_dtd_document_root'] = $doctype->name();
		//$branch['dx_notations'] = $doctype->notations();
		$branch['dx_public_id'] = $doctype->public_id();
		$branch['dx_system_id'] = $doctype->system_id();

		$branch[$root_name] = xmlhasharray($root);
		break;
	case XML_ELEMENT_NODE :
		if ($node->has_child_nodes())
		{
			$children = $node->child_nodes();
			for ($i=0; $i<count($children); $i++)
			{
				$child =& $children[$i];
				$child_name = $child->node_name();

				switch ($child->node_type())
				{
				case XML_ELEMENT_NODE :
					if (!is_array($branch[$child_name]))
						$branch[$child_name] = array();
					$newbranch = xmlhasharray($child);
					$branch[$child_name][] = $newbranch;
					break;
				case XML_TEXT_NODE :
					$text = trim($child->node_value());
					if ($text)
						$branch['dx_text'] .= $text;
					break;
				case XML_COMMENT_NODE :
					$branch['dx_comments'][] = $child->node_value();
					break;
				}
			}
		}
	break;
	}

	return $branch;
}

function get_infos($node, $param_list)
{
	$result = array();
	
	for ($i=0; $i<count($node); $i++)
	{
		$tab = array();
		foreach ($param_list as $param => $param_list2)
		{
			if (is_integer($param))
				$param = $param_list2;
			$text = $node[$i][$param][0]['dx_text'];
			if (!$text)
			{
				if (is_array($param_list2))
					$tab[$param] = get_infos($node[$i][$param], $param_list2);
			}
			else
				$tab[$param] = $text;
		}
		$name = $node[$i]['name'][0]['dx_text'];
		if ($name)
			$result[$name] = $tab;
		else
			foreach ($tab as $key => $val)
				$result[$key] = $val;
	}

	return $result;
}

// $val = 'ip4' | 'ip6' | 'mac'
function replace_host($tab, $tag, $host)
{
	global		$g_ifs, $g_hosts, $g_routers, $g_host_groups;

	$ret = array();
	if (!is_array($tab))
		$tab = array($tab);

	foreach ($tab as $el)
	{
		if (array_key_exists($host, $g_ifs))
			$list = array($host);
		elseif (array_key_exists($host, $g_hosts))
			$list = $g_hosts[$host];
		elseif (array_key_exists($host, $g_host_groups))
			$list = $g_host_groups[$host];
		else
			$list = array();

		foreach ($list as $ifn)
		{
			$str = $el;
			if ($g_ifs[$ifn]['ip4'])
				$str = preg_replace("/#".$tag."_ip4/", $g_ifs[$ifn]['ip4'], $str);
			if ($g_ifs[$ifn]['ip6'])
				$str = preg_replace("/#".$tag."_ip6/", $g_ifs[$ifn]['ip6'], $str);
			if ($g_ifs[$ifn]['mac'])
				$str = preg_replace("/#".$tag."_mac/", $g_ifs[$ifn]['mac'], $str);
			$ret[] = $str;
		}
	}
	return $ret;
}

function replace_to_str($tab)
{
	$str = "";
	foreach ($tab as $el)
		if (!preg_match("/#\w+_\w+/", $el))
			$r.= $el;
	return $r;
}

// IPv4 C-class only
function get_subnet($ip)
{
	$z = explode(".", $ip);
	$z[3] = 0;
	return implode(".", $z);
}

function simple_cost($node_list, $node, $next_node)
{
        return 1;
}
                                                                                                                                                                         
                                                                                                                                                                         
function straight_line_heuristic($node_list, $start_node, $stop_node, $node, $next_node)
{
        return simple_cost($node_list, $node, $next_node);
}
                                                                                                                                                                         
                                                                                                                                                                         
function sel($node_list, $successor_list, $node)
{
        return 0;
}

function find_subnets(&$routers)
{
        $tab = array();
                                                                                                                                                                         
        foreach ($routers as $k => $v)
                foreach ($v['ips'] as $ip => $mac)
                        $tab[get_subnet($ip)][] = $k;
                                                                                                                                                                         
        foreach ($tab as $k => $v)
                $tab[$k] = array_unique($v);
                                                                                                                                                                         
        return $tab;
}

function create_nodes(&$routers, &$subnets)
{
        $tab = array();
                                                                                                                                                                         
        foreach ($subnets as $k => $v)
                foreach ($v as $r)
                        foreach ($routers[$r][ips] as $ip => $mac)
                                $tab[$k]['successors'][] = array(get_subnet($ip), array($r, $mac));
                                                                                                                                                                         
        return $tab;
}

?>
