<?php
/*

Copyright (c)2003 DuckCorp(tm) and RtpNet(tm)



This file is part of DFTK.

DFTK is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

DFTK is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DFTK; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/**
 * @package		dftk
 * @author		Duck <duck@DuckCorp.org>
 * @author		Rtp <rtp@rtp-net.org>
 * @copyright	Copyright (c)2003 DuckCorp(tm) and RtpNet(tm)
 * @license		http://www.gnu.org/licenses/gpl.html					GNU General Public License
 * @version		0.4.0
 */


/**
 * DFTK Stdout Output Class
 *
 * @package		dftk
 * @subpackage	dftk-output
 * @author		Duck <duck@DuckCorp.org>
 *
 * @access		public
 */
class DftkOutputOneshot extends DftkOutput
{
	/**
	 * Filename for old output backup
	 *
	 * @access		private
	 * @var			string
	 */
	var $_filename;

	/**
	 * Output object
	 *
	 * @access		private
	 * @var			object DftkOutput
	 */
	var $_output;

	/**
	 * Constructor
	 *
	 * @access		public
	 * @param		object DftkDaTraceManager	&$tracemgr			Language Manager
	 * @param		string						$filename			Log file name
	 * @param		object DftkOutput			$output				Output object
	 */
	function DftkOutputOneshot(&$tracemgr, $filename, &$output)
	{
		DftkOutput::DftkOutput($tracemgr);
		
		$this->_filename = $filename;
		$this->_output =& $output;

		register_shutdown_function(array(&$this, "_DftkOutputOneshot"));
	}

	/**
	 * Destructor
	 *
	 * @access		private
	 */
	function _DftkOutputOneshot()
	{
	}

	/**
	 * Flush output
	 *
	 * Result :
	 *  + 'output_changed' : true if output has changed since last call
	 *
	 * @access		public
	 * @return		object DftkDaTrace		$r						Trace
	 */
	function &flush_output()
	{
		$r =& $this->_tracemgr->create_trace();

		if (file_exists($this->_filename))
		{
			if (!function_exists('md5_file'))
				$old_md5 = md5(implode("", file($this->_filename)));
			else
				$old_md5 = md5_file($this->_filename);
		}
		else
			$old_md5="";

		$content = $this->_header.$this->_content.$this->_footer;
		$md5 = md5($content);

		if ($md5 != $old_md5)
		{
			$r2 =& $this->_save_output();
			$r->merge_traces($r2);

			if ($content)
			{
				$this->_output->set_header($this->_header);
				$this->_output->clear_content();
				$this->_output->add_content($this->_content);
				$this->_output->set_footer($this->_footer);

				$this->_output->flush_output();
			}

			$r->set_result('output_changed', true);
		}
		else
			$r->set_result('output_changed', false);

		$r2 =& DftkOutput::flush_output();
		$r->merge_traces($r2);

		return $r;
	}

	/**
	 * Save output
	 *
	 * @access		private
	 * @return		object DftkDaTrace		$r						Trace
	 */
	function &_save_output()
	{
		$r =& $this->_tracemgr->create_trace();

		$fp = fopen($this->_filename, "w");
		if (!$fp)
			$r->add_event('dftk-output_ioerr');

		if (!$r->has_error())
		{
			if (!fwrite($fp, $this->_header.$this->_content.$this->_footer))
				$r->add_event('dftk-output_ioerr');

			if (!$r->has_error())
			{
				if(!fclose($fp))
					$r->add_event('dftk-output_ioerr');
			}
		}

		return $r;
	}
}

?>
