<?php
/*

Copyright (c)2003 DuckCorp(tm) and RtpNet(tm)



This file is part of DFTK.

DFTK is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

DFTK is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DFTK; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/**
 * @package		dftk
 * @author		Duck <duck@DuckCorp.org>
 * @author		Rtp <rtp@rtp-net.org>
 * @copyright	Copyright (c)2003 DuckCorp(tm) and RtpNet(tm)
 * @license		http://www.gnu.org/licenses/gpl.html					GNU General Public License
 * @version		0.4.0
 */


/**
 * DFTK LDAP Base Class
 *
 * @package		dftk
 * @subpackage	dftk-ldap
 * @author		Duck <duck@DuckCorp.org>
 *
 * @access		public
 * @abstract
 */
class DftkLdapBase
{
	/**
	 * Trace Manager
	 *
	 * @access		private
	 * @var			string
	 */
	var	$_tracemgr;

	/**
	 * Constructor
	 *
	 * @access		public
	 * @param		object DftkDaTraceManager	&$tracemgr			Language Manager
	 */
	function DftkLdapBase(&$tracemgr)
	{
		$this->_tracemgr =& $tracemgr;

		if (!$this->_tracemgr->is_module("DFTK-LDAP"))
			$this->_tracemgr->register_traces("DFTK-LDAP",DFTK_ROOT_PATH."/ldap/traces/");
		
		register_shutdown_function(array(&$this, "_DftkLdapBase"));
	}

	/**
	 * Destructor
	 *
	 * @access		private
	 */
	function _DftkLdapBase()
	{
	}
}

?>
